/*------------------------------------------------------------------------------*
 * File Name: Import_Utils.h													*
 * Creation: 																	*
 * Purpose: OriginC Source C file												*
 * Copyright (c) ABCD Corp.	2000, 2001, 2002, 2003, 2004, 2005, 2006, 2007		*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 * SY 08/06/2004 QA70-6780 v8.0116 LLOC_FOR_IMPORT								*
 * SY 08/31/2004 QA70-6472 v8.0127 IMPORT_INFO_STORAGE_CLEANUP					*
 * SY 01/11/2005 QA70-5658 v8.0184 SUPPORT_MULTI_DELIMITER						*
 * EJP 2005-02-16 v8.0193 IMPWIZ_TREAT_CONSECUTIVE_TABS_AND_SPACES_AS_ONE		*
 * SY 05/17/2005 QA70-7650 v8.0235 MORE_IMPORT_MODE_IN_OLD_ASCII_IMPORT_DLG		*
 * EJP 2005-10-20 v8.0321 QA70-7921 XFUNC_TO_IMPORT_FILES						*
 * EJP 2006-10-27 v8.0502 QA70-9073 XUNIT_AND_XLONGNAME_FOR_X_AXIS_TITLE		*
 *	Hong 08/11/08 QA80-11980 VARAIBLE_TO_USER_PARAMETER_USING_NICE_NAME			*
 *------------------------------------------------------------------------------*/
 
////////////////////////////////////////////////////////////////////////////////////
#ifndef _IMPORT_UTILS_H
#define _IMPORT_UTILS_H

/// AW 07/19/06 WAV_UNDEPENDENT_IMPOT_UTIL
/*
/// SY 08/06/2004 QA70-6780 v8.0116 LLOC_FOR_IMPORT
typedef struct {		// 8-byte RIFF header, 
	DWORD id;			// identifier
	DWORD len;			// remaining length after this header = file_length - 8
} RIFFHDR;

typedef struct {
	DWORD id;			// WAVE file identifier
} WAVEHDR;

#define CHUNKHDR RIFFHDR

////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////
// PCM format, we only support PCM format now
typedef struct {			// Microsoft WAVE FORMAT PCM format
	// format common field
	WORD wFormatTag;		// format category { 0001 = PCM }
	WORD wChannels;			// number of channels, { 1 = mono | 2 = stereo }
	DWORD dwSamplesPerSec;	// sampling rate
	DWORD dwAvgBytesPerSec;	// for buffer estimation
	WORD wBlockAlign;		// block alignment ( in bytes) { 1 | 2 | 4 }
	// PCM format special
	WORD wBitsPerSample;	// Sample size { 8 | 16 }
/// AW 07/11/06 MORE_ON_WAVE  
//} FMTWAVEFORMAT;
	WORD wExtraFormat;		// EXtra format bytes, 
} FMTWAVEFORMAT;
/// END MORE_ON_WAVE

////////////////////////////////////////////////////////////////////////////////
// WAVE form wFormatTag IDs, we only support PCM format now
// flags for wFormatTag field of WAVEFORMAT
#define WAVE_FORMAT_PCM     0x0001
////////////////////////////////////////////////////////////////////////////////


////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////
enum {
	IMPERR_FILE_NONE = 0,
	IMPERR_FILE_OPEN,
	IMPERR_FILE_READ,
	IMPERR_FILE_TYPE,
	IMPERR_FILE_SIZE,
	IMPERR_FILE_PCM,
	IMPERR_FILE_DUPLICA_FMT,
	IMPERR_FILE_CHUNK_SYN,
	IMPERR_FILE_SAMPLE_BIT,
	IMPERR_WRONG_COL,	/// AW 06/20/06 QA80-8767 v8.0432 SET_EVEN_SPACED_X

};
*/
/// END WAV_UNDEPENDENT_IMPOT_UTIL

/// EJP 01-11-2005 v8.0183 QA70-6555 NEW_IMPORT_MODES
enum {
	IW_LIST_IMPMODE_AUTO = 0,
	IW_LIST_IMPMODE_REPLACE,
	IW_LIST_IMPMODE_NEW_BOOKS,
	IW_LIST_IMPMODE_NEW_SHEETS,
	IW_LIST_IMPMODE_NEW_COLS,
	IW_LIST_IMPMODE_NEW_ROWS
};
/// end NEW_IMPORT_MODES

///---Sim 01-30-2007 GENERAL_IMPORT_MODE_LIST
//enum {
	//IW_FLAG_IMPMODE_AUTO 		= 0x0001,
	//IW_FLAG_IMPMODE_REPLACE 	= 0x0002,
	//IW_FLAG_IMPMODE_NEW_BOOKS	= 0x0004,
	//IW_FLAG_IMPMODE_NEW_SHEETS	= 0x0008,
	//IW_FLAG_IMPMODE_NEW_COLS	= 0x0010,
	//IW_FLAG_IMPMODE_NEW_ROWS	= 0x0020,
//};
///---END GENERAL_IMPORT_MODE_LIST

/// Hong 9/06/06 MOVE_FORM_FILEIMPORT_TO_IMPORT_UTILS
// Move from IWAscHdrVarToken.c
enum {
	IW_FN_VAR_FULL = 0,		// path, name, and extension
	IW_FN_VAR_PATH,			// path only
	IW_FN_VAR_NAME_EXT,		// name and extension only
	IW_FN_VAR_NAME_ONLY,	// name only, no extension
	IW_FN_NUM_LINES			// number of FN lines
};
/// end MOVE_FORM_FILEIMPORT_TO_IMPORT_UTILS

////////////////////////////////////////////////////////////////////////////////
/// AW 07/19/06 WAV_UNDEPENDENT_IMPOT_UTIL
/*
#define idFOURCC( ch0, ch1, ch2, ch3 )				\
		( (DWORD)(BYTE)(ch0) | ( (DWORD)(BYTE)(ch1) << 8 ) |	\
		( (DWORD)(BYTE)(ch2) << 16 ) | ( (DWORD)(BYTE)(ch3) << 24 ) )

////////////////////////////////////////////////////////////////////////////
//              WAVE FILE IDS
#define RIFF_ID 		idFOURCC('R', 'I', 'F', 'F')	//0x46464952 'FFIR'
#define WAVE_ID			idFOURCC('W', 'A', 'V', 'E')	//0x45564157 'EVAW'
////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////
//              RIFF CHUNKS IDS
#define RIFFCHUNK_FMT	idFOURCC('f', 'm', 't', ' ')	//0x20746d66 ' tmf'
#define RIFFCHUNK_DATA	idFOURCC('d', 'a', 't', 'a')	//0x61746164 'atad'
#define RIFFCHUNK_LIST	idFOURCC('L', 'I', 'S', 'T')	//0x5453494c 'TSIL'
////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////
//              LIST SUBCHUNKS IDS
#define RIFFLIST_INFO	idFOURCC('I', 'N', 'F', 'O')	//INFO list
////////////////////////////////////////////////////////////////////////////
*/
/// END WAV_UNDEPENDENT_IMPOT_UTIL

void unpack_data_to_channel(TreeNode& trParent, vector<short>& vData, int nNumChannels);
/// end LLOC_FOR_IMPORT

void convertShortsToCommaSeparatedStrings(string &strTarget, vector<short> &vSource);
void convertCommaSeparatedStringsToShorts(vector<short>& vTarget, LPCSTR lpcstrSource);

/// SY 01/11/2005 QA70-5658 v8.0184 SUPPORT_MULTI_DELIMITER
// This function will convert all delims in string to first specified delim.
void ConvertMultiDelimToSingle(string &str, vector<int>& vnDelim);
int CheckDelimiters(string& str);
BOOL DelimtersToString(vector<int>& vnDelims, string& strDelims);
/// end SUPPORT_MULTI_DELIMITER

/// EJP 2005-02-16 v8.0193 IMPWIZ_TREAT_CONSECUTIVE_TABS_AND_SPACES_AS_ONE
void delete_consecutive_chars(string &str, char cFind);
/// end IMPWIZ_TREAT_CONSECUTIVE_TABS_AND_SPACES_AS_ONE

/// SY 05/17/2005 QA70-7650 v8.0235 MORE_IMPORT_MODE_IN_OLD_ASCII_IMPORT_DLG
int _GetImportModeFromListIndex(int nListIndex);
int _GetListIndexFromImportMode(int nImportMode);
/// end MORE_IMPORT_MODE_IN_OLD_ASCII_IMPORT_DLG

///---Sim 01-30-2007 GENERAL_IMPORT_MODE_LIST
//string getImportModeListString(string &strMaping = NULL, DWORD dwCtrl = \
		//IW_FLAG_IMPMODE_AUTO | IW_FLAG_IMPMODE_REPLACE | IW_FLAG_IMPMODE_NEW_BOOKS \
		 //| IW_FLAG_IMPMODE_NEW_SHEETS | IW_FLAG_IMPMODE_NEW_COLS | IW_FLAG_IMPMODE_NEW_ROWS);
//int getImportModeFromListIndex(int nListIndex, DWORD dwCtrl = \
		//IW_FLAG_IMPMODE_AUTO | IW_FLAG_IMPMODE_REPLACE | IW_FLAG_IMPMODE_NEW_BOOKS \
		 //| IW_FLAG_IMPMODE_NEW_SHEETS | IW_FLAG_IMPMODE_NEW_COLS | IW_FLAG_IMPMODE_NEW_ROWS);
//int getListIndexFromImportMode(int nImportMode, DWORD dwCtrl = \
		//IW_FLAG_IMPMODE_AUTO | IW_FLAG_IMPMODE_REPLACE | IW_FLAG_IMPMODE_NEW_BOOKS \
		 //| IW_FLAG_IMPMODE_NEW_SHEETS | IW_FLAG_IMPMODE_NEW_COLS | IW_FLAG_IMPMODE_NEW_ROWS);
///---END GENERAL_IMPORT_MODE_LIST

/// EJP 2005-10-20 v8.0321 QA70-7921 XFUNC_TO_IMPORT_FILES
BOOL set_ascimp_delimter(ASCIMP& ai, LPCSTR lpcszDelimiters);
BOOL import_asc(LPCSTR lpcszFileName, Worksheet& wks, int nDelim, LPCSTR pszPartial, int nMode, string& strRange);
/// end XFUNC_TO_IMPORT_FILES
/// Hong 9/06/06 REMOVE_BINIMP
/**
		Read a binary header parameter from a file into a string.
	Parameters:
		strDest = destination string to receive the header parameter value
		fil	= source file to read the header parameter from
		nType = header parameter data type
		nOffset = byte offset from the begining of the file
		nSize = size of data in bytes
	Return:
		true for success, else false.
*/
bool ReadBinaryHeaderParam(string &strDest, file &fil, int nType, int nOffset, int nSize, bool bLittleEndian=true);
/// end REMOVE_BINIMP
/// Hong 9/06/06 MOVE_FORM_FILEIMPORT_TO_IMPORT_UTILS
/// Hong 08/11/08 QA80-11980 VARAIBLE_TO_USER_PARAMETER_USING_NICE_NAME
//BOOL import_and_check_variables_by_scanning( StringArray& saVarNames, StringArray& saVarValues, LPCSTR lpcszDataFile, const TreeNode& tnFilter );
BOOL import_and_check_variables_by_scanning( StringArray& saVarNames, StringArray& saVarValues, LPCSTR lpcszDataFile, const TreeNode& tnFilter, StringArray* psaRawNames = NULL);
/// end VARAIBLE_TO_USER_PARAMETER_USING_NICE_NAME
BOOL get_lines_for_variables(StringArray& saLines, LPCSTR lpcszDataFile, TreeNode& tnFilter);
BOOL get_tokens_by_delim(StringArray& saTokens, LPCSTR lpcszLine, TreeNode& tnToken);
/// Hong 08/11/08 QA80-11980 VARAIBLE_TO_USER_PARAMETER_USING_NICE_NAME
//BOOL get_variable_from_data_file(string& strName, string& strValue, StringArray& saLines, TreeNode& tnVar);	
BOOL get_variable_from_data_file(string& strName, string& strValue, StringArray& saLines, TreeNode& tnVar, string* pstrRawName = NULL);
/// end /// Hong 08/11/08 QA80-11980 VARAIBLE_TO_USER_PARAMETER_USING_NICE_NAME
BOOL CallImportWizardXFunction(Layer& lyTarget, LPCSTR lpcszFile, int nFile, TreeNode& tnFilter, TreeNode& tnInfo, int event, int& nRet);											
/// end MOVE_FORM_FILEIMPORT_TO_IMPORT_UTILS	
/// Hong 9/26/06 ADD_VARIABLE_TO_PAGE_INFO
/// Hong 08/11/08 QA80-11980 VARAIBLE_TO_USER_PARAMETER_USING_NICE_NAME
//BOOL get_variables_from_data_file(
	//StringArray& saVarNames, StringArray& saVarValues,
	//LPCSTR lpcszDataFile,
	//TreeNode& tnFilter,
	//BOOL bFromFileName);
BOOL get_variables_from_data_file(
	StringArray& saVarNames, StringArray& saVarValues,
	LPCSTR lpcszDataFile,
	TreeNode& tnFilter,
	BOOL bFromFileName,
	StringArray* psaVarNiceNames = NULL
	);
/// end VARAIBLE_TO_USER_PARAMETER_USING_NICE_NAME
	
BOOL import_variables_by_function(
	StringArray& saVarNames,
	StringArray& saVarValues,
	LPCSTR lpcszDataFile,
	const TreeNode& tnFilter);
	
/// Hong 08/11/08 QA80-11980 VARAIBLE_TO_USER_PARAMETER_USING_NICE_NAME
//BOOL import_variables_from_ascii_file(
	//StringArray& saVarNames,
	//StringArray& saVarValues,
	//LPCSTR lpcszDataFile,
	//const TreeNode& tnFilter);
BOOL import_variables_from_ascii_file(
	StringArray& saVarNames,
	StringArray& saVarValues,
	LPCSTR lpcszDataFile,
	const TreeNode& tnFilter,
	StringArray* psaVarNiceNames = NULL
	);
/// end VARAIBLE_TO_USER_PARAMETER_USING_NICE_NAME
	
/// Hong 08/11/08 QA80-11980 VARAIBLE_TO_USER_PARAMETER_USING_NICE_NAME
//BOOL import_binary_header_variables(
	//StringArray& saVarNames, StringArray& saVarValues, 
	//LPCSTR lpcszDataFile, const TreeNode& tnFilter);
BOOL import_binary_header_variables(
	StringArray& saVarNames, 
	StringArray& saVarValues, 
	LPCSTR lpcszDataFile, 
	const TreeNode& tnFilter,
	StringArray* psaVarNiceNames = NULL
	);
/// end VARAIBLE_TO_USER_PARAMETER_USING_NICE_NAME
/// END ADD_VARIABLE_TO_PAGE_INFO

/// EJP 2006-10-27 v8.0502 QA70-9073 XUNIT_AND_XLONGNAME_FOR_X_AXIS_TITLE
/**
		Set a column's XUnits and XLongName values.
	Parameters:
		col = destination column
		lpcszXUnits	= source XUnits value, pass NULL to set only XLongName
		lpcszXLongName = source XLongName value, pass NULL to set only XUnits
	Return:
		true for success, false for failure.
*/
bool setColXUnitsAndLongName(Column& col, LPCSTR lpcszXUnits, LPCSTR lpcszXLongName);
/// end XUNIT_AND_XLONGNAME_FOR_X_AXIS_TITLE

#endif // _IMPORT_UTILS_H

